#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N, K;
    cin >> N >> K;

    vector<int> lokacijeProdavnica(K);
    vector<long long int> populacija(N);

    for (int i = 0; i < K; ++i) {
        cin >> lokacijeProdavnica[i];
    }

    for (int i = 0; i < N; ++i) {
        cin >> populacija[i];
    }

    long long int ukupnaPopulacija = 0;
    for (int i = 0; i < N; ++i) {
        ukupnaPopulacija += populacija[i];
    }

    long long int preostalaPopulacija = ukupnaPopulacija;

    for (int lokacija : lokacijeProdavnica) {
        preostalaPopulacija -= populacija[lokacija - 1];
    }

    if (preostalaPopulacija <= ukupnaPopulacija / 2) {
        cout << "-1" << endl;
        return 0;
    }
    if(preostalaPopulacija==ukupnaPopulacija){
        cout << "1";
        return 0;
    }

    vector<pair<int, int>> gradovi;
    for (int i = 0; i < N; ++i) {
        if (find(lokacijeProdavnica.begin(), lokacijeProdavnica.end(), i + 1) == lokacijeProdavnica.end()) {
            gradovi.push_back({populacija[i], i + 1});
        }
    }

    sort(gradovi.rbegin(), gradovi.rend());

    int potrebnoProdavnica = 0;
    int pokrivenaPopulacija = 0;

    for (auto grad : gradovi) {
        if (pokrivenaPopulacija > ukupnaPopulacija / 2) {
            break;
        }
        pokrivenaPopulacija += grad.first;
        potrebnoProdavnica++;
    }

    cout << potrebnoProdavnica << endl;

    return 0;
}